#pragma once

#ifdef __cplusplus
extern "C" {
#endif

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>

#include "../export.h"
#include "session/session_protocol.h"

typedef struct pro_pro_config pro_pro_config;
struct pro_pro_config {
    bytes64 rotating_privkey;
    session_protocol_pro_proof proof;
};

/// Verify the proof was signed by the `verify_pubkey` and that the `rotating_privkey` in the `pro`
/// config rederives to the `rotating_pubkey` embedded in the proof.
///
/// Inputs:
/// - `proof` -- Proof to verify
/// - `verify_pubkey` -- Array of bytes containing the public key to (typically the Session Pro
///   Backend public key) verify the proof against.
/// - `verify_pubkey_len` -- Length of the `verify_pubkey` this must be 32 bytes, but is
///   parameterised to detect errors about incorrectly sized arrays by the caller.
///
/// Outputs:
/// - `bytes32` -- The 32 byte hash calculated from the proof
LIBSESSION_EXPORT bool pro_config_verify_signature(
        pro_pro_config const* pro, uint8_t const* verify_pubkey, size_t verify_pubkey_len)
        NON_NULL_ARG(1, 2);

#ifdef __cplusplus
}  // extern "C"
#endif
